/* --COPYRIGHT--,BSD
 * Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
#include "structure.h"


const struct Element Left = {
              .inputPxselRegister = (uint8_t *)&P2SEL,
              .inputPxsel2Register = (uint8_t *)&P2SEL2,
              .inputBits = BIT0,
              .maxResponse = 27+ 50,
              .threshold = 27
};

const struct Element Right = {
              .inputPxselRegister = (uint8_t *)&P2SEL,
              .inputPxsel2Register = (uint8_t *)&P2SEL2,
              .inputBits = BIT5,
              .maxResponse = 39 + 45,
              .threshold = 39
};


// Grip Sensors Definition
const struct Sensor Grip =
{
                  .halDefinition = RO_PINOSC_TA0_WDTp,
                  .numElements = 2,
                  .baseOffset = 0,
                  .arrayPtr[0] = &Left,
                  .arrayPtr[1] = &Right,
                  .measGateSource = GATE_WDT_SMCLK,
                  .accumulationCycles= WDTp_GATE_8192
};

const struct Element BUT1 = {

              .inputPxselRegister = (uint8_t *)&P1SEL,
              .inputPxsel2Register = (uint8_t *)&P1SEL2,
              .inputBits = BIT5,
              .maxResponse = 9 + 50,
              .threshold = 9
};

const struct Element BUT2 = {
              .inputPxselRegister = (uint8_t *)&P1SEL,
              .inputPxsel2Register = (uint8_t *)&P1SEL2,
              .inputBits = BIT6,
              .maxResponse = 10 + 50,
              .threshold = 10
};


// Buttons Definition
const struct Sensor Buttons =
{
                  .halDefinition = RO_PINOSC_TA0_WDTp,
                  .numElements = 2,
                  .baseOffset = 2,
                  .arrayPtr[0] = &BUT1,
                  .arrayPtr[1] = &BUT2,
                  .measGateSource = GATE_WDT_SMCLK,
                  .accumulationCycles = WDTp_GATE_8192
};
